package cn.com.duiba.activity.center.api.remoteservice.quizz;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.quizz.DuibaQuizzStockDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 
 * ClassName: RemoteDuibaQuizzStockService <br/>
 * date: 2016年12月1日 下午5:11:30 <br/>
 *
 * @version 
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteDuibaQuizzStockService {
    /**
     * 
     * subStock:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param subNumber
     * @return
     * @since JDK 1.6
     */
    public int subStock(Long id, Integer subNumber);

    /**
     * 
     * addStock:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param addNumber
     * @return
     * @since JDK 1.6
     */
	public int addStock(Long id, Integer addNumber);

	/**
	 * 
	 * findRemaining:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param optionId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto findRemaining(Long optionId);

    //from manager
	/**
	 * 
	 * findByQuizzOptionId:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param questionOptionId
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto findByQuizzOptionId(Long questionOptionId);

	/**
	 * 
	 * findByQuizzOptionIds:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaQuizzStockDto> findByQuizzOptionIds(List<Long> list);

    
	/**
	 * 
	 * updateStockAdd:(这里用一句话描述这个方法的作用). <br/>
	 * 增加库存
	 * @param id
	 * @param stockAdd
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStockAdd(Long id, Integer stockAdd);

	/**
	 * 
	 * updateStockSub:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param id
	 * @param stockSub
	 * @return
	 * @since JDK 1.6
	 */
	public int updateStockSub(Long id, Integer stockSub);

	/**
	 * 
	 * add:(这里用一句话描述这个方法的作用). <br/>
	 * @param quizzStockDO
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto add(DuibaQuizzStockDto quizzStockDO);

	/**
	 * 
	 * addBatch:(这里用一句话描述这个方法的作用). <br/>
	 * 
	 * @param list
	 * @return
	 * @since JDK 1.6
	 */
	public List<DuibaQuizzStockDto> addBatch(List<DuibaQuizzStockDto> list);
	
	/**
	 * 
	 * findById:(这里用一句话描述这个方法的作用). <br/>
	 * @param id
	 * @return
	 * @since JDK 1.6
	 */
	public DuibaQuizzStockDto findById(Long id);
}
