package cn.com.duiba.activity.center.api.dto.tlcb;

import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * @author: pengyi
 * @description:
 * @date: 2022/6/10 上午9:55
 */
public class TaskUnitConfigDto implements Serializable {

    private static final long serialVersionUID = 5588716591888672501L;
    private Long id;
    /** appId */
    @NotNull(message = "appId不能为空")
    private Long appId;
    /** app活动id，活动长id */
    private Long operatingActivityId;
    /** 活动名称 */
    @NotBlank(message = "组件标题不能为空")
    private String actName;
    /** 活动规则 */
    @NotBlank(message = "任务规则不能为空")
    private String actRule;
    /** 组件任务 */
    @NotEmpty(message = "任务列表不能为空")
    private List<TaskConfigDto> taskList;
    /** 界面配置 */
    @NotBlank(message = "界面配置不能为空")
    private String interfaceConfig;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getOperatingActivityId() {
        return operatingActivityId;
    }

    public void setOperatingActivityId(Long operatingActivityId) {
        this.operatingActivityId = operatingActivityId;
    }

    public String getActName() {
        return actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public String getActRule() {
        return actRule;
    }

    public void setActRule(String actRule) {
        this.actRule = actRule;
    }

    public List<TaskConfigDto> getTaskList() {
        return taskList;
    }

    public void setTaskList(List<TaskConfigDto> taskList) {
        this.taskList = taskList;
    }

    public String getInterfaceConfig() {
        return interfaceConfig;
    }

    public void setInterfaceConfig(String interfaceConfig) {
        this.interfaceConfig = interfaceConfig;
    }
}
