package cn.com.duiba.activity.center.api.enums;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @author liukai
 * @date 2019/04/03
 */
public enum BetOpenAwardTypeEnum {
    BET_DELAY(1, "延迟开奖"),
    BET_ON_TIME(2, "定时开奖"),
    ;

    private Integer code;
    private String desc;

    public static final ImmutableMap<Integer, BetOpenAwardTypeEnum> BETOPENAWARDTYPEENUM_MAP;

    static {
        Map<Integer, BetOpenAwardTypeEnum> temp = Maps.newHashMap();
        for (BetOpenAwardTypeEnum betOpenAwardTypeEnum : values()) {
            temp.put(betOpenAwardTypeEnum.getCode(), betOpenAwardTypeEnum);
        }
        BETOPENAWARDTYPEENUM_MAP = ImmutableMap.copyOf(temp);
    }

    BetOpenAwardTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static BetOpenAwardTypeEnum getBetActivityBonusTypeNum(Integer code) {
        if(BETOPENAWARDTYPEENUM_MAP.containsKey(code)){
            return BETOPENAWARDTYPEENUM_MAP.get(code);
        }else{
            return null;
        }
    }


}
