package cn.com.duiba.activity.center.api.remoteservice.equity;

import cn.com.duiba.activity.center.api.dto.equity.EquityVerificationRecordDto;
import cn.com.duiba.activity.center.api.request.equity.VerificationRecordFindPageRequest;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @program: activity-all
 * @description: 匹配身份核销记录
 * @author: Simba
 * @create: 2019-09-09 11:24
 **/
@AdvancedFeignClient
public interface RemoteEquityVerificationRecordService {

    Long save(EquityVerificationRecordDto dto);

    int deleteById(Long id);

    Integer deleteRecordById(Long id);

    int updateById(EquityVerificationRecordDto dto);

    EquityVerificationRecordDto getById(Long id);

    List<EquityVerificationRecordDto> listByIds(List<Long> ids);

    List<EquityVerificationRecordDto> listByEquityIds(List<Long> equityIds);

    List<EquityVerificationRecordDto> selectByCidAndEquityIds(Long appId, Long cid, List<Long> equityIds);

    Page<EquityVerificationRecordDto> findPageByConditions(VerificationRecordFindPageRequest request);

    Long findPageCountByConditions(VerificationRecordFindPageRequest request);

    int update2Success(Long id);

    int update2Fail(Long id, String failReason);

    EquityVerificationRecordDto listByOrderId(String orderId);

    List<EquityVerificationRecordDto> findProcessListByAppId(Long appId);

    List<EquityVerificationRecordDto> listByOrderIds(List<String> orderIds);

}

