package cn.com.duiba.activity.center.api.remoteservice.guess;

import cn.com.duiba.activity.center.api.dto.guess.DuibaGuessBrickDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by yansen on 16/7/18.
 */
@AdvancedFeignClient
public interface RemoteDuibaGuessBrickService {
    /**
     * 
     * find:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaGuessBrickDto find(Long id);

    /**
     * 
     * getBrickContentById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public String getBrickContentById(Long id);

    /**
     * 
     * findNoContent:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public DuibaGuessBrickDto findNoContent(Long id);

    /**
     * 
     * getBrickPrizeContentById:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @return
     * @since JDK 1.6
     */
    public String getBrickPrizeContentById(Long id);

    /**
     * 
     * insert:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param duibaGuessBrick
     * @return
     * @since JDK 1.6
     */
    public DuibaGuessBrickDto insert(DuibaGuessBrickDto duibaGuessBrick);

    /**
     * 
     * update4Admin:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @param title
     * @param content
     * @param prizeContent
     * @param md5
     * @since JDK 1.6
     */
    public void update4Admin(Long id, String title, String content, String prizeContent, String md5);

    /**
     * 
     * findByTitle:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param title
     * @return
     * @since JDK 1.6
     */
    public DuibaGuessBrickDto findByTitle(String title);

    /**
     * 
     * open:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    public void open(Long id);

    /**
     * 
     * disable:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param id
     * @since JDK 1.6
     */
    public void disable(Long id);

    /**
     * 
     * findPage:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param offset
     * @param max
     * @return
     * @since JDK 1.6
     */
    public List<DuibaGuessBrickDto> findPage(Integer offset, Integer max);

    /**
     * 
     * findPageCount:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public Long findPageCount();

    /**
     * 
     * findAll:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @return
     * @since JDK 1.6
     */
    public List<DuibaGuessBrickDto> findAll();
}
