package cn.com.duiba.activity.center.api.enums.centscan;

/**
 * Created by sunyan on 2019/10/9.
 */
public enum BankTypeEnum {
    BANK_ICBC("ICBC", "工商银行"),
    BANK_ABC("ABC", "农业银行"),
    BANK_BOC("BOC", "中国银行"),
    BANK_CCB("CCB", "建设银行"),
    BANK_CMB("CMB", "招商银行"),
    BANK_CITIC("CITIC", "中信银行")
            ;


    private String code;
    private String desc;

    BankTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BankTypeEnum getByCode(String code) {
        if (code == null) {
            return null;
        }
        for (BankTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
