package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益确认入库枚举类
 **/
public enum EquityComfirmEnum {

    UN_CONFIRM(1, "待确认入库"),
    CONFIRM(2, "已确认入库"),
    ;
    private Integer code;
    private String desc;

    EquityComfirmEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquityComfirmEnum ofValue(Integer code) {
        for (EquityComfirmEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

