package cn.com.duiba.activity.center.api.remoteservice.openredpacket;

import cn.com.duiba.activity.center.api.dto.openredpacket.OpenRedPacketHelpRecordDto;
import cn.com.duiba.activity.center.api.dto.openredpacket.OpenRedPacketRecordDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: zhengjianhao
 * @date: 2019/4/28 17:13
 * @description: 拆红包工具-拆红包帮拆记录
 */
@AdvancedFeignClient
public interface RemoteOpenRedPacketHelpRecordService {

	/**
	 * 新增
	 */
	int add(OpenRedPacketHelpRecordDto entity);

	/**
	 * 根据拆红包记录id查询帮拆记录列表
	 */
	List<OpenRedPacketHelpRecordDto> getByRecordId(Long recordId);

	/**
	 * 根据用户id查询帮拆记录
	 */
	List<OpenRedPacketHelpRecordDto> getByCidAndOpenType(Long consumerId, Long configId, Integer openType);

	/**
	 * 根据活动id查询帮拆记录(用于弹幕展示)
	 * @param configId
	 * @return
	 */
	List<OpenRedPacketHelpRecordDto> listHelpRecord(Long configId);
}
