package cn.com.duiba.activity.center.api.remoteservice.pyramidspread;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.pyramidspread.SpreadConsumerBindInvitorResultDto;
import cn.com.duiba.activity.center.api.dto.pyramidspread.SpreadConsumerBonusDto;
import cn.com.duiba.activity.center.api.dto.pyramidspread.SpreadConsumerIndexConsumerDataDto;
import cn.com.duiba.activity.center.api.dto.pyramidspread.SpreadConsumerLevelThreeLeaderDto;
import cn.com.duiba.activity.center.api.dto.pyramidspread.SpreadConsumerLevelTwoLeaderDto;
import cn.com.duiba.activity.center.api.enums.pyramidspread.SpreadConsumerReapBonusResultEnum;
import cn.com.duiba.activity.center.api.params.pyramidspread.SpreadConsumerBindInvitorParam;
import cn.com.duiba.activity.center.api.params.pyramidspread.SpreadConsumerBonusListQueryParam;
import cn.com.duiba.activity.center.api.params.pyramidspread.SpreadConsumerLeaderListQueryParam;
import cn.com.duiba.activity.center.api.params.pyramidspread.SpreadConsumerReapBonusParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 师徒体系用户数据远程服务
* Created by HePeng on 2019/04/24 13:40.
*/
@AdvancedFeignClient
public interface RemoteSpreadConsumerService {
    /**
     * 首页用户数据
     * @param actId
     * @param consumerId
     * @return
     */
    SpreadConsumerIndexConsumerDataDto indexConsumerData(Long actId, Long consumerId);

    /**
     * 用户的大财团列表
     * @param queryParam
     * @return
     */
    List<SpreadConsumerLevelTwoLeaderDto> levelTwoLeaderList(SpreadConsumerLeaderListQueryParam queryParam);

    /**
     * 用户的小财团列表
     * @param queryParam
     * @return
     */
    PaginationDto<SpreadConsumerLevelThreeLeaderDto> levelThreeLeaderList(SpreadConsumerLeaderListQueryParam queryParam);

    /**
     * 红包列表
     * @param queryParam
     * @return
     */
    List<SpreadConsumerBonusDto> bonusList(SpreadConsumerBonusListQueryParam queryParam);

    /**
     * 绑定邀请人
     * @param bindInvitorParam
     * @return
     */
    SpreadConsumerBindInvitorResultDto bindInvitor(SpreadConsumerBindInvitorParam bindInvitorParam);

    /**
     * 提交收割红包任务
     * @param reapBonusParam
     * @return
     */
    SpreadConsumerReapBonusResultEnum submitReapBonusTask(SpreadConsumerReapBonusParam reapBonusParam);
}
