package cn.com.duiba.activity.center.api.dto.underseagame;

import java.io.Serializable;
import java.util.Date;

/**
 * 海底游戏机抽奖记录
 * @Author: xuwei
 * @Date: 2020/07/16
 */
public class UnderseaGamePrizeRecordDto implements Serializable {

    private static final long serialVersionUID = -6543253983082567992L;

    /**
     * 奖品状态-未领取
     */
    public static final int STATUS_INIT = 0;
     /**
      * 奖品状态-领取成功
      */
    public static final int STATUS_SUCCESS = 1;
     /**
      * 奖品状态-领取失败
      */
    public static final int STATUS_FAILED = 2;



    /**
     * 主键
     */
    private Long id;

    /**
     * 海底游戏机配置ID
     */
    private Long configId;

    /**
     * 游戏开始记录ID
     */
    private Long startId;

    /**
     * 关卡 (1, 2, 3)，如果是所有关卡完成后抽奖，则为0
     */
    private Integer roundIndex;

    /**
     * 用户ID
     */
    private Long consumerId;

    /**
     * 奖品表配置ID，为0则为谢谢参与
     */
    private Long prizeConfigId;

    /**
     * 中奖商品ID
     */
    private Long appItemId;

    /**
     * 奖品类型
     */
    private String prizeType;

    /**
     * 奖品扩展信息（面额、优惠券券码等）
     */
    private String prizeValue;

    /**
     * 奖品状态。0:未领取，1:领取成功，2:领取失败
     */
    private Integer prizeStatus;

    /**
     * 主订单ID
     */
    private Long orderId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConfigId() {
        return configId;
    }

    public void setConfigId(Long configId) {
        this.configId = configId;
    }

    public Long getStartId() {
        return startId;
    }

    public void setStartId(Long startId) {
        this.startId = startId;
    }

    public Integer getRoundIndex() {
        return roundIndex;
    }

    public void setRoundIndex(Integer roundIndex) {
        this.roundIndex = roundIndex;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getPrizeConfigId() {
        return prizeConfigId;
    }

    public void setPrizeConfigId(Long prizeConfigId) {
        this.prizeConfigId = prizeConfigId;
    }

    public Long getAppItemId() {
        return appItemId;
    }

    public void setAppItemId(Long appItemId) {
        this.appItemId = appItemId;
    }

    public String getPrizeType() {
        return prizeType;
    }

    public void setPrizeType(String prizeType) {
        this.prizeType = prizeType == null ? null : prizeType.trim();
    }

    public String getPrizeValue() {
        return prizeValue;
    }

    public void setPrizeValue(String prizeValue) {
        this.prizeValue = prizeValue == null ? null : prizeValue.trim();
    }

    public Integer getPrizeStatus() {
        return prizeStatus;
    }

    public void setPrizeStatus(Integer prizeStatus) {
        this.prizeStatus = prizeStatus;
    }

    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}