package cn.com.duiba.activity.center.api.remoteservice.newgamecenter;

import cn.com.duiba.activity.center.api.dto.newgamecenter.NewGameCenterSpecifyDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/09/03
 */
@AdvancedFeignClient
public interface RemoteNewGameCenterSpecifyBackendService {
    /**
     * 定向游戏中心
     * @param gameCenterConfigId 游戏中心配置id
     * @param appIds appId 1,2
     * @return true or false
     */
    Boolean insert(Long gameCenterConfigId, String appIds);

    /**
     * 删除定向
     * @param id 定向配置id
     * @return 影响行数
     */
    Integer delete(Long id);

    /**
     * 获取游戏中心定向的appId列表
     * @param gameCenterConfigId 游戏中心配置id
     * @return List<NewGameCenterSpecifyDto>
     */
    List<NewGameCenterSpecifyDto> list(Long gameCenterConfigId);

    /**
     * 获取app定向的游戏中心配置
     * @param appId appId
     * @return NewGameCenterSpecifyDto
     */
    NewGameCenterSpecifyDto findByAppId(Long appId);
}
