package cn.com.duiba.activity.center.api.domain.entity.wanda;

import lombok.Data;
import java.util.Date;

/**
 * 万达供销存订单取消记录表实体类
 */
@Data
public class WandaOrderCancelRecordEntity {
    /**
     * 主键ID，自增
     */
    private Long id;

    /**
     * 应用ID，标识调用来源系统
     */
    private Long appId;

    /**
     * 平台订单号，全局唯一
     */
    private String orderNum;

    /**
     * 开发者订单号（外部订单号），用于对接幂等
     */
    private String outOrderNum;

    /**
     * 用户ID，标识订单所属用户
     */
    private String userId;

    /**
     * 商品名称，用于展示和统计
     */
    private String productName;

    /**
     * 取消原因，支持长文本描述
     */
    private String cancelReason;

    /**
     * 取消状态：0-取消中, 1-成功, 2-取消失败
     */
    private Integer cancelStatus;

    /**
     * 创建时间，索引字段
     */
    private Date gmtCreate;

    /**
     * 最后更新时间
     */
    private Date gmtModified;
}