package cn.com.duiba.activity.center.api.enums.equity;

import java.util.Objects;

/**
 * @program: activity-center
 * @description: 权益类型 -子类型枚举类
 * @author: 刘凯
 **/
public enum EquitySubTypeEnum {
    HTTP_EXCHANGE(1, "接口传递白名单"),
    WHITELIST_EXCHANGE(2, "上传白名单表格"),
    ;
    private Integer code;
    private String desc;

    EquitySubTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static EquitySubTypeEnum ofValue(Integer code) {
        for (EquitySubTypeEnum equityTypeEnum : values()) {
            if (Objects.equals(equityTypeEnum.getCode(), code)) {
                return equityTypeEnum;
            }
        }
        return null;
    }
}

