package cn.com.duiba.activity.center.api.remoteservice.activity;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.activity.LotteryToolDto;
import cn.com.duiba.activity.center.api.dto.activity.LotteryToolPageQueryParam;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 抽签工具表RemoteService接口
 * 
 * @author cgq
 * @date 2025-01-19
 */
@AdvancedFeignClient
public interface RemoteLotteryToolService {
    
    /**
     * 插入抽签工具记录
     * 
     * @param dto 抽签工具DTO
     * @return 影响行数
     * @throws BizException 业务异常
     */
    int insert(LotteryToolDto dto) throws BizException;
    
    /**
     * 批量插入抽签工具记录
     * 
     * @param dtoList 抽签工具DTO列表
     * @return 影响行数
     * @throws BizException 业务异常
     */
    int batchInsert(List<LotteryToolDto> dtoList) throws BizException;
    
    /**
     * 根据ID更新抽签工具记录
     * 
     * @param dto 抽签工具DTO
     * @return 影响行数
     * @throws BizException 业务异常
     */
    int updateById(LotteryToolDto dto) throws BizException;
    
    /**
     * 根据ID查询抽签工具记录
     * 
     * @param id 主键ID
     * @return 抽签工具DTO
     */
    LotteryToolDto findById(Long id);
    
    /**
     * 根据商品ID查询抽签工具列表
     * 
     * @param appItemId 商品ID
     * @return 抽签工具DTO列表
     */
    LotteryToolDto findByAppItemId(Long appItemId);
    
    /**
     * 根据商品ID列表查询抽签工具列表
     * 
     * @param appItemIds 商品ID列表
     * @return 抽签工具DTO列表
     */
    List<LotteryToolDto> findByAppItemIds(List<Long> appItemIds);
    
    /**
     * 根据商品ID和抽奖状态查询抽签工具列表
     * 
     * @param appItemId 商品ID
     * @param prizeDrawStatus 抽奖状态
     * @return 抽签工具DTO列表
     */
    LotteryToolDto findByAppItemIdAndPrizeDrawStatus(Long appItemId, Integer prizeDrawStatus);
    
    /**
     * 根据创建人ID查询抽签工具列表
     * 
     * @param createOperatorId 创建人ID
     * @return 抽签工具DTO列表
     */
    List<LotteryToolDto> findByCreateOperatorId(Long createOperatorId);
    
    /**
     * 根据抽奖状态查询抽签工具列表
     * 
     * @param prizeDrawStatus 抽奖状态
     * @return 抽签工具DTO列表
     */
    List<LotteryToolDto> findByPrizeDrawStatus(Integer prizeDrawStatus);
    
    /**
     * 分页查询抽签工具
     *
     * @param param 分页及筛选参数
     * @return 分页结果
     */
    Page<LotteryToolDto> pageQuery(LotteryToolPageQueryParam param);
    
    /**
     * 根据ID逻辑删除抽签工具记录
     * 
     * @param id 主键ID
     * @return 影响行数
     */
    int deleteById(Long id);
} 