package cn.com.duiba.activity.center.api.remoteservice.app_survey;

import cn.com.duiba.activity.center.api.dto.app_survey.AppSurveyLibraryDto;
import cn.com.duiba.activity.center.api.params.app_survey.SurveyLibraryPageParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAppSurveyLibraryService {

    /**
    * 新增
    **/
    Long insert(AppSurveyLibraryDto dto);

    /**
    * 刪除
    **/
    int delete(Long id);

    /**
    * 更新
    * @author huakai
    **/
    int update(AppSurveyLibraryDto dto);

    /**
    * 查询 根据主键 id 查询
    * @author huakai
    **/
    AppSurveyLibraryDto load(Long id);

    /**
     * 根据应用id和题库名称查询
     * @param appId 应用id
     * @param title 题库名称
     * @return 题库
     */
    List<AppSurveyLibraryDto> selectByLibraryTitle(Long appId, String title);

    /**
    * 查询 分页查询
    **/
    Page<AppSurveyLibraryDto> pageList(SurveyLibraryPageParam pageParam);


}