package cn.com.duiba.activity.center.api.domain.entity.wanda;

import lombok.Data;
import java.util.Date;

/**
 * 万达开票记录实体类
 */
@Data
public class WandaTaxTicketRecordEntity {
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 开发者用户ID
     */
    private String uid;

    /**
     * 兑吧订单号
     */
    private String orderNum;

    /**
     * 诺诺流水号
     */
    private String seriesNo;

    /**
     * 开票金额
     */
    private Long ticketMoney;

    /**
     * 运费
     */
    private Integer ticketExpressMoney;

    /**
     * 处理状态 0 初始化 1 开票中 2 开票成功 3 开票失败
     */
    private Integer handleStatus;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 开票结果文件
     */
    private String resultFile;

    /**
     * 发票号
     */
    private String ticketNo;

    /**
     * 发票类型 0 数电发票
     */
    private Integer ticketType;

    /**
     * 抬头类型 0 个人 1企业
     */
    private Integer headerType;

    /**
     * 抬头名称
     */
    private String headerName;

    /**
     * 业务纳税编号
     */
    private String taxNo;

    /**
     * 发送电子邮箱
     */
    private String sendEmail;

    /**
     * 扩展字段
     */
    private String extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}