package cn.com.duiba.activity.center.api.remoteservice.bargain;

import cn.com.duiba.activity.center.api.dto.bargain.BargainRuleInfoDto;
import cn.com.duiba.activity.center.api.params.bargain.BargainRuleInfoParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/12/6 0006 16:03
 */
@AdvancedFeignClient
public interface RemoteBargainRuleInfoService {

    /**
     * 插入
     *
     * @param pojo
     * @return
     */
     Long insert(BargainRuleInfoDto pojo);

    /**
     * 批量插入
     *
     * @param pojos
     * @return ids集合，按照顺序
     */
    List<Long> batchInsert(List<BargainRuleInfoDto> pojos);

    /**
     * 分页查询砍价活动列表
     * 1.过滤已经删除的
     *
     * @param pojo
     * @return
     */
     List<BargainRuleInfoDto> listByParams(BargainRuleInfoParam pojo);

    /**
     * 修改
     * 1.id必传，根据id修改
     *
     * @param pojo
     * @return
     */
     int update(BargainRuleInfoDto pojo);

    /**
     * 删除
     *
     * @param id
     * @return
     */
     int deleteById(Long id);

    /**
     * 通过id查询规则
     * @param id
     * @return
     */
    BargainRuleInfoDto findById(Long id);
}
