package cn.com.duiba.activity.center.api.enums.creditsfarm;

/**
 * 任务类型 1-签到 2-种植 3-分享
 */
public enum TaskTypeEnum {
    TASK_TYPE_SIGN(1, "签到"),
    TASK_TYPE_CROP(2, "种植"),
    TASK_TYPE_SHARE(3, "分享"),
    ;


    private Integer code;
    private String desc;

    TaskTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TaskTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (TaskTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
