package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.params.wanda.EditGroggeryDisParam;
import cn.com.duiba.activity.center.api.params.wanda.QueryDisGoodsPageParam;
import cn.com.duiba.activity.center.api.params.wanda.WandaDisGoodsParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达分销商品远程服务接口
 *
 * @author zhengzhihao
 */
@AdvancedFeignClient
public interface RemoteWandaDisGoodsService {
    /**
     * 根据分销类型和分销唯一编码得到 开发者商品id
     */
    Page<Long> listItemIdsPage(QueryDisGoodsPageParam param) throws BizException;

    /**
     * 批量插入分销关系
     */
    Boolean batchInsertDisGoods(List<WandaDisGoodsParam> params) throws BizException;

    /**
     * 批量删除分销关系
     */
    Boolean batchDeleteByTypeAndUniqueCodes(Integer disType, List<String> disUniqueCodes);

    /**
     * 增量更新酒店分销商品关系
     * @param param 更新参数
     * @return 更新结果
     */
    Boolean incrementalUpdateDisGoods(EditGroggeryDisParam param) throws BizException;


    /**
     * 根据分销类型和分销唯一编码查询商品ID列表
     * @param disType 分销类型
     * @param disUniqueCode 分销唯一编码
     * @return 商品ID列表
     */
    List<Long> listItemIdsByTypeAndUniqueCode(Integer disType, String disUniqueCode);
}
