/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.api.enums.singleAward;

import cn.com.duiba.activity.center.api.tool.DateUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public enum SingleAwardDateTypeEnum {
    DAY("day", "\u65e5"),
    WEEK("week", "\u5468"),
    MONTH("month", "\u6708"),
    FOREVER("forever", "\u6c38\u4e45");

    private String type;
    private String desc;

    private SingleAwardDateTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SingleAwardDateTypeEnum getByType(String type) {
        SingleAwardDateTypeEnum[] values;
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        for (SingleAwardDateTypeEnum value : values = SingleAwardDateTypeEnum.values()) {
            if (!Objects.equals(value.getType(), type)) continue;
            return value;
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Date getStartDate(String dateType) {
        if (dateType == null || Objects.equals(dateType, FOREVER.getType())) {
            return null;
        }
        if (Objects.equals(dateType, DAY.getType())) {
            return DateUtils.getDayStartTime((Date)new Date());
        }
        if (Objects.equals(dateType, WEEK.getType())) {
            return DateUtil.getMondayDate(new Date());
        }
        if (Objects.equals(dateType, MONTH.getType())) {
            Date monthFirstDay = DateUtils.getMonthDayByIndex((Date)new Date(), (int)1);
            return DateUtils.getDayStartTime((Date)monthFirstDay);
        }
        return null;
    }

    public static Date getEndDate(String dateType) {
        if (dateType == null || Objects.equals(dateType, FOREVER.getType())) {
            return null;
        }
        if (Objects.equals(dateType, DAY.getType())) {
            return DateUtils.getDayEndTime((Date)new Date());
        }
        if (Objects.equals(dateType, WEEK.getType())) {
            return DateUtil.getSundayDate(new Date());
        }
        if (Objects.equals(dateType, MONTH.getType())) {
            return SingleAwardDateTypeEnum.getEndDayOfMonth();
        }
        return null;
    }

    public static Date getEndDayOfMonth() {
        Calendar cale = Calendar.getInstance();
        cale.add(2, 1);
        cale.set(5, 0);
        cale.set(11, 23);
        cale.set(12, 59);
        cale.set(13, 59);
        return cale.getTime();
    }
}

