package cn.com.duiba.activity.center.api.enums.pyramidspread;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/04/19 11:04.
 */
public enum PyramidSpreadPlayTypeEnum {
    TYPE_TWO_LEVEL(0, "二级裂变"),
    TYPE_THREE_LEVEL(1, "三级裂变"),
    ;

    private static final ImmutableMap<Integer, PyramidSpreadPlayTypeEnum> ALL_MAP;
    static {
        Map<Integer, PyramidSpreadPlayTypeEnum> temp = Maps.newHashMap();
        for(PyramidSpreadPlayTypeEnum enumVal: PyramidSpreadPlayTypeEnum.values()) {
            temp.put(enumVal.getType(), enumVal);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    public static PyramidSpreadPlayTypeEnum getByType(Integer type) {
        return ALL_MAP.get(type);
    }

    private int type;
    private String desc;

    PyramidSpreadPlayTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
