package cn.com.duiba.activity.center.api.remoteservice.cms;


import cn.com.duiba.activity.center.api.dto.CmsSendPrizeDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author: LuHui
 * @date: 2024/5/24 18:22
 * @description: 奖品发放远程服务接口
 */
@AdvancedFeignClient
public interface RemoteCmsSendPrizeService {

    /**
     * 创建记录
     *
     * @param cmsSendPrizeDto 记录信息
     * @return 新创建记录的ID
     */
    long create(CmsSendPrizeDto cmsSendPrizeDto);

    /**
     * 更新记录状态为处理中
     *
     * @param id 记录ID
     * @return 是否更新成功
     */
    boolean updateToProcessing(Long id);

    /**
     * 更新记录状态为已完成
     *
     * @param id 记录ID
     * @param result 处理结果
     * @param resultFile 结果文件OSS地址
     * @return 是否更新成功
     */
    boolean updateToFinished(Long id, String result, String resultFile);

    /**
     * 分页查询
     *
     * @param pageNo 页码
     * @param pageSize 每页大小
     * @param appId 应用ID
     * @return 分页结果
     */
    Page<CmsSendPrizeDto> pageQuery(int pageSize, int pageNo, Long appId);

    /**
     * 根据ID查询记录
     *
     * @param id 记录ID
     * @return 记录信息
     */
    CmsSendPrizeDto findById(Long id);
}