package cn.com.duiba.activity.center.api.remoteservice.wanda;

import cn.com.duiba.activity.center.api.dto.wanda.WandaOrderCancelRecordDto;
import cn.com.duiba.activity.center.api.dto.wanda.WandaOrderCancelRecordQueryDto;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 万达供销存订单取消记录远程服务接口
 */
@AdvancedFeignClient
public interface RemoteWandaOrderCancelRecordService {

    /**
     * 创建一条订单取消记录
     */
    Long createOrderCancelRecord(WandaOrderCancelRecordDto dto);

    /**
     * 修改一条记录（根据id修改状态）
     */
    Boolean updateOrderCancelRecord(WandaOrderCancelRecordDto dto);

    /**
     * 分页查询所有记录
     */
    Page<WandaOrderCancelRecordDto> pageQueryOrderCancelRecord(WandaOrderCancelRecordQueryDto queryDto);

    /**
     * 查询一条记录（根据id）
     */
    WandaOrderCancelRecordDto queryOrderCancelRecordById(Long id);

    /**
     * 查询一条记录（根据订单号）
     */
    WandaOrderCancelRecordDto queryOrderCancelRecordByOrderNum(String orderNum);
}