package cn.com.duiba.activity.center.api.dto.wanda;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 万达酒店集采审核订单DTO
 */
@Data
public class WandaGroupBuyingAuditOrderDto implements Serializable {
    /**
     * 主键
     */
    private Long id;
    
    /**
     * 应用ID
     */
    private Long appId;
    
    /**
     * 订单号
     */
    private String orderNum;
    
    /**
     * 下单时间
     */
    private Date orderTime;
    
    /**
     * 酒店ID
     */
    private Long groggreyId;
    
    /**
     * 商品名称，多个商品使用$分割
     */
    private String itemTitle;
    
    /**
     * 订单类型 0 集采订单 1 代发订单
     */
    private Integer orderType;
    
    /**
     * 审核状态 0 待审核 1 通过 2 拒绝
     */
    private Integer auditStatus;
    
    /**
     * 审核意见
     */
    private String auditDesc;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;
    
    /**
     * 修改时间
     */
    private Date gmtModified;
}