package cn.com.duiba.activity.center.api.dto.wanda;

import java.io.Serializable;

/**
 * @Description 专题活动。
 * @Author edan
 * @Date 2025/3/19 20:24
 **/
public class WandaSubjectActQueryDto implements Serializable {
    /**
     * 活动名称
     */
    private String actName;

    /**
     * 活动状态 0-未开始 1-进行中 2-已结束 3-已关闭 4-未开始&进行中
     */
    private Integer status;

    /**
     * 页码
     */
    private Integer pageNum = 1;

    /**
     * 每页大小
     */
    private Integer pageSize = 10;

    public Integer getOffset() {
        return (pageNum - 1) * pageSize;
    }

    public String getActName() {
        return actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
