package cn.com.duiba.activity.center.api.remoteservice.seedredpacket;

import cn.com.duiba.activity.center.api.dto.seedredpacket.SeedRedPacketUserMarkDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author zhengjianhao
 * @date 18/7/6
 * @description 可提现用户标记
 */
@AdvancedFeignClient
public interface RemoteAppSeedRedPacketMarkService {

	/**
	 * 增加标记用户
	 */
	void add(SeedRedPacketUserMarkDto seedRedPacketUserMarkDto);

	/**
	 * 按app、活动查询被标记用户list
	 */
	List<SeedRedPacketUserMarkDto> getListByAppAndActivity(Long appId, Long activityId);

	/**
	 * 按app、活动查询被标记用户数量
	 */
	Integer getCountByAppAndActivity(Long appId, Long activityId);
}
