package cn.com.duiba.activity.center.api.remoteservice.common;

import cn.com.duiba.activity.center.api.dto.common.ImportDto;
import cn.com.duiba.activity.center.api.dto.common.ImportFileDto;
import cn.com.duiba.activity.center.api.params.ImportPageParam;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by hong
 * time 2022/9/6.
 */
@AdvancedFeignClient
public interface RemoteImportService {

    Long insert(ImportDto dto) throws BizException;

    int deleteById(Long id);

    int update(ImportDto dto) throws BizException;

    ImportDto findById(Long id);

    Long importFile(ImportDto dto);

    Page<ImportDto> page(ImportPageParam param);

    /**
     * 根据业务id列表，批量查询上传成功的记录
     */
    List<ImportDto> selectSuccessListByActivityIds(Long appId, List<Long> bizIdList, String bizType);

    /**
     * 获取导入成功的总记录数量
     */
    Long findTotalUserCount(Long appId, Long bizId, String bizType);

}
