package cn.com.duiba.activity.center.api.remoteservice.hsbc;

import cn.com.duiba.activity.center.api.dto.hsbc.HsbcChanceOrderDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

@AdvancedFeignClient
public interface RemoteHsbcChanceOrderService {
    /**
     * 创建机会订单
     * @param hsbcChanceOrderDto 机会商品订单
     */
    Long create(HsbcChanceOrderDto hsbcChanceOrderDto);

    /**
     * @param id 机会商品订单id
     * 根据id查询机会商品订单
     */
    HsbcChanceOrderDto findById(Long id);

    /**
     * 根据用户id和兑换记录id查询机会商品订单
     * @param consumerId 用户id
     * @param consumerRecordId 兑换记录id
     * @return 机会商品订单
     */
    HsbcChanceOrderDto findByIdConsumerRecordId(Long consumerId,Long consumerRecordId);

    /**
     * 根据用户id和活动id查询机会商品订单
     * @param consumerId 通用活动表id
     * @param activityId 用户id
     * @return 机会商品订单
     */
    List<HsbcChanceOrderDto> findByConsumerInActivity(Long consumerId, Long activityId);

    /**
     * 根据三方订单号查询机会商品订单
     * @param thirdNum 三方订单号
     * @return 机会商品订单
     */
    HsbcChanceOrderDto findByThirdNum(String thirdNum);

    /**
     * 更新机会商品订单状态
     * @param id 机会商品订单id
     * @param orderStatus 订单状态
     */
    void updateOrderStatus(Long id,String orderStatus);

    /**
     * 更新机会商品订单状态
     * @param id 机会商品订单id
     * @param useStatus 使用状态状态
     */
    void updateOrderUseStatus(Long id,Integer useStatus);

    /**
     * 标记订单中奖
     * @param id 机会商品订单id
     * @param consumerRecordId 兑换记录id
     */
    void markOrderWinPrize(Long id,Long consumerRecordId);

    /**
     * 标记订单未中奖
     * @param id 机会商品订单id
     */
    void markOrderLostPrize(Long id);

    /**
     * 标记订单领奖
     * @param id 机会商品订单id
     * @param orderId 订id
     */
    void markOrderReveivePrize(Long id,Long orderId);
}
