package cn.com.duiba.activity.common.center.api.remoteservice.specify;

import cn.com.duiba.activity.common.center.api.dto.wallet.WalletAccountRelationDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * 活动定向表  应用场景为uk形式的 即至多只能有一个活动只能定向给一个app的场景
 * Created by hww on 2018/7/11 上午10:08.
 */
@AdvancedFeignClient
public interface RemoteActivitySpecifyUniqueService {

    /**
     * 根据活动id 活动类型 查询所有的定向关系
     */
    List<WalletAccountRelationDto> findAllByActivity(Long activityId, Integer relationType);

    /**
     * 根据定向关系id删除对应的定向关系
     */
    int deleteById(Long id);

    /**
     * 批量保存定向关系
     */
    int saveBatch(List<Long> appIds, Long activityId, Integer relationType);

    /**
     * 根据appId查询所有的定向关系
     */
    List<WalletAccountRelationDto> findAllByAppIds(List<Long> appIds, Integer relationType);

    /**
     * 根据活动id和活动类型查询各个活动的定向app数量
     * map.key = 活动id
     * map.value = 定向app数量
     */
    Map<Long, Integer> findGroupCountByActivity(List<Long> activityIds, Integer relationType);

    /**
     * 根据活动id和活动类型删除该活动所有的定向关系
     * @return
     */
    int deleteByRelation(Long activityId, Integer relationType);

}
