package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.activity.common.center.api.dto.ConsumerAccountUniquenessKeyDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountWithLogsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsDto;
import cn.com.duiba.activity.common.center.api.dto.consumeraccount.ConsumerAccountsLogDto;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountBizTypeEnum;
import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;
import cn.com.duiba.activity.common.center.api.params.ConsumerAccountInsertParam;
import cn.com.duiba.activity.common.center.api.params.wallet.DateRangeWalletAccountParam;
import cn.com.duiba.activity.common.center.api.params.wallet.PaginationDateRangeWalletAccountParam;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountAddAmountRequest;
import cn.com.duiba.activity.common.center.api.req.consumeraccounts.AccountAmountModifyRequest;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountAddAmountResponse;
import cn.com.duiba.activity.common.center.api.rsp.consumeraccounts.AccountModifyResponse;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 用户账户服务
 * Created by hww on 2018/3/23 下午4:56.
 */
@AdvancedFeignClient
public interface RemoteConsumerAccountService {

    /**
     * 根据兑吧用户id和账号类型查询账户
     * 账号不存在时返回null
     * @param consumerId 兑吧用户id
     * @param accountType 账号类型 {@link AccountTypeEnum}
     * @return
     * @throws BizException
     */
    @Deprecated
    ConsumerAccountsDto find(Long consumerId, AccountTypeEnum accountType) throws BizException;
    ConsumerAccountsDto findByUniquenessKey(ConsumerAccountUniquenessKeyDto uniKey) throws BizException;

    /**
     * 根据兑吧用户id和账号类型查询账户
     * 若账户不存在，则创建新账户并返回
     * @param consumerId 兑吧用户id
     * @param appId 用户所属应用id 用于创建账户
     * @param partnerUserId 开发者用户id 用于创建账户
     * @param accountType 账号类型 {@link AccountTypeEnum}
     * @return
     * @throws BizException
     */
    @Deprecated
    ConsumerAccountsDto findOrInsert(Long consumerId, Long appId, String partnerUserId, AccountTypeEnum accountType) throws BizException;
    ConsumerAccountsDto searchOrInsert(ConsumerAccountInsertParam param) throws BizException;

    /**
     * 用户账户充值接口
     * 若账户不存在会先创建账户
     * @param request 账户充值接口入参列表 {@link AccountAddAmountRequest}
     * @return
     */
    @Deprecated
    AccountAddAmountResponse addAmount(AccountAddAmountRequest request) throws BizException;

    /**
     * 用户账户充值接口
     * 若账户不存在会先创建账户
     * @param request 账户充值接口入参列表 {@link AccountAmountModifyRequest}
     * @return
     */
    AccountModifyResponse accountModify(AccountAmountModifyRequest request) throws BizException;
    
	/**
	 * 分页查询用户经验流水
	 * @param consumerId
	 * @param appId
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	List<ConsumerAccountsLogDto> walletDetail(String accountId, Integer pageNo, Integer pageSize) throws BizException;

    /**
     * 查询用户账户相关信息，用户一段时间内的账户流水等信息
     * @param paginationDateRangeWalletAccountParam
     * @return
     */
	ConsumerAccountWithLogsDto getConsumerAccountWithDateRangeWalletDetail(PaginationDateRangeWalletAccountParam paginationDateRangeWalletAccountParam);

    /**
     * 获取用户账户一段时间内获取的金额总数（排除提现返还相关）
     * @param dateRangeWalletAccountParam
     * @return
     */
	Long getDateRangeInAmount(DateRangeWalletAccountParam dateRangeWalletAccountParam);

    /**
     * 根据用户id、账户类型、业务类型查询当天的收入
     * 只能用户全局账户，不支持账户id上带有活动id的账户类型
     * 方法会返回null
     */
	Long selectDailyRecord(Long consumerId, AccountTypeEnum accountType, AccountBizTypeEnum bizType);

    /**
     *  获取截止昨日账户余额(只计入收到的红包总额)
     */
    Long selectYesterdayAccount(Long consumerId, Long appId);

}
