package cn.com.duiba.activity.common.center.api.enums.consumeraccounts;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 账户类型
 * 最多支持100种
 */
public enum AccountTypeEnum {

    GLOBAL_REWARD("全局红包", 0),
    HAND_REWARD("手气红包", 1),
    PET_FEEDER("宠物养成饲养员账户",2),
    SIGN_VIRTUAL_CARD("签到补签虚拟卡", 3),
    EXP("经验账户", 4),
    FZ_GUESS("飞猪竞猜定制账户", 5),
    ALL_WALLET("全局钱包", 6),
    AQY_WALLET("爱奇艺钱包", 7),
    PET_WANDER("外来宠物用户账户",8),
    TOTAL_REWARD("累计红包账户",9),
    ALL_WALLET_BUDGET("全局钱包预算账户", 10),
    MASTER_DISCIPLE_SYSTEM("百姓网师徒体系账户", 11),
    LOTTERY_SQUARE("红包广场", 12),
    SHUQI_REFLUX("书旗回流", 13),
    ;

    /**
     * 支持提现的账户类型
     */
    private static final ImmutableSet<AccountTypeEnum> ACCESS_DRAWS;
    
    /**
     * 支持提现的账户类型
     */
    private static final ImmutableSet<AccountTypeEnum> EXPIRE_DRAWS;

    /**
     * 所有类型的map映射
     */
    private static final ImmutableMap<Integer, AccountTypeEnum> ALL_MAP;

    static {
        ACCESS_DRAWS = ImmutableSet.of(GLOBAL_REWARD, HAND_REWARD, FZ_GUESS,ALL_WALLET,AQY_WALLET, MASTER_DISCIPLE_SYSTEM,LOTTERY_SQUARE,SHUQI_REFLUX);
        EXPIRE_DRAWS = ImmutableSet.of(ALL_WALLET);
        Map<Integer, AccountTypeEnum> temp = Maps.newHashMap();
        for (AccountTypeEnum type : values()) {
            temp.put(type.getCode(), type);
        }
        ALL_MAP = ImmutableMap.copyOf(temp);
    }

    /**
     * 判断当前账户类型是否支持提现
     * @param input
     * @return
     */
    public static boolean isAccessDraws(AccountTypeEnum input) {
        return ACCESS_DRAWS.contains(input);
    }
    
    /**
     * 判断当前账户类型是否支持提现
     * @param input
     * @return
     */
    public static boolean isExpireDraws(AccountTypeEnum input) {
        return EXPIRE_DRAWS.contains(input);
    }

    public static AccountTypeEnum find(Integer code) {
        return ALL_MAP.get(code);
    }

    AccountTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
