package cn.com.duiba.activity.common.center.api.enums;

import com.google.common.collect.Maps;
import java.util.Map;

/**
 * @author liugq
 * @date 2019/03/01
 * 应用类型： 0-兑吧 1-开发者自有
 */
public enum AppTypeEnum {
    /**
     * 来自兑吧
     */
    DUIBA(0),
    /**
     * 开发者自有
     */
    DEVELOPER(1);


    private Integer code;

    AppTypeEnum(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    private static Map<Integer,AppTypeEnum> typeMap = Maps.newHashMap();
    static{
        for(AppTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static AppTypeEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        return typeMap.get(code);
    }

}
