package cn.com.duiba.activity.common.center.api.remoteservice.consumeraccount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 用户提现次数相关服务
 * Created by HePeng on 2018/11/16 14:46.
 */
@AdvancedFeignClient
public interface RemoteWithdrawTimesService {
    /**
     * 用户访问积分商城（签到）
     * @param consumerId
     * @return
     */
    boolean addLoginRecord(Long consumerId);

    /**
     * 获取用户可用提现次数
     * @param appId
     * @param consumerId
     * @return
     * 0表示次数用完，
     * -1表示使用次数已达到上限，返回后可用于判断，返回给前端需要改为0: max(availableTimes, 0)
     */
    int getAvailableTimes(Long appId, Long consumerId);
}
