package cn.com.duiba.activity.common.center.api.remoteservice.operating;

import java.util.List;

import cn.com.duiba.activity.common.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteOperatingActivityBackendService {

	/**
	 * 根据兑吧activityId和subType批量查询入库活动工具
	 * 
	 * @param activityId
	 * @param type
	 * @param deleted  (true 时   查询所有 包括已删除的数据)
	 * 
	 * 管理员端使用 无缓存 手机端不可使用
	 */
	List<OperatingActivityDto> findOpListByActivityIdAndType(Long activityId, String type,Boolean deleted);
	
	/**
	 * 批量更新活动  积分和活动标题
	 * 
	 * @param update
	 * 
	 * 管理员端使用 无缓存 手机端不可使用
	 */
	Integer updateOperatingActivitylist(List<OperatingActivityDto> update);
}
