package cn.com.duiba.activity.common.center.api.remoteservice.market;

import cn.com.duiba.activity.common.center.api.dto.market.MarketTempBaseDto;
import cn.com.duiba.activity.common.center.api.dto.market.MarketTempCMSDto;
import cn.com.duiba.activity.common.center.api.dto.market.MarketTempDto;
import cn.com.duiba.activity.common.center.api.dto.market.MarketTempMobileDto;
import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2019/3/6
 */
@AdvancedFeignClient
public interface RemoteMarketTempService {

    /**
     * 新增
     * @param dto
     * @return
     */
    boolean insertMarketTemp(MarketTempDto dto);

    /**
     * 修改
     * @param dto
     * @return
     */
    boolean updateMarketTemp(MarketTempDto dto);

    /**
     * 获取营销落地页简单模版列表
     * @return
     */
    List<MarketTempBaseDto> listMarketTemp();

    /**
     * 通过主键id获取营销落地页模版
     * @param id
     * @return
     */
    MarketTempDto getMarketTemp(Long id);

    /**
     * 获取营销落地页手机端模版
     * @param identifying
     * @param environment
     * @return
     */
    MarketTempMobileDto getMarketTempMobile(String identifying, Integer environment);

    /**
     * 获取营销落地页开发者后台模版
     * @param identifying
     * @param environment
     * @return
     */
    MarketTempCMSDto getMarketTempCms(String identifying, Integer environment);

    /**
     * 获取营销落地页简单模版列表（分页）
     * @return
     */
    Page<MarketTempBaseDto> pageMarketTemp(int start, int size);

    /**
     * 获取营销落地页简单模版列表个数
     * @return
     */
    int countMarketTemp();
}
