package cn.com.duiba.activity.common.center.api.remoteservice.bigtext;

import cn.com.duiba.activity.common.center.api.dto.bigtext.BigTextDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 大字段统一存储
 * @author xiaoxuda
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteBigTextService {
	/**
	 * 信息保存
	 * @param dto
	 * @return 主键ID
	 */
	Long insert(BigTextDto dto);

	/**
	 * 根据ID更新信息
	 * @param id
	 * @param content
	 * @return
	 */
	Boolean updateById(Long id, String content);

	/**
	 * 根据ID删除数据
	 * @param id
	 * @return
	 */
	Boolean deleteById(Long id);

	/**
	 * 根据ID查询信息
	 * @param id
	 * @return
	 */
	BigTextDto selectById(Long id);

	/**
	 * 根据ID批量查询
	 * @param ids
	 * @return
	 */
	List<BigTextDto> selectByIds(List<Long> ids);
}