package cn.com.duiba.activity.common.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 大字段涉及业务类型
 * @author xiaoxuda
 */
public enum BigTextTypeEnum {
    SIGN_FOR_NEW(1, "拉新签到"),
    COMMON_SHARE(2, "通用分享"),
    CUSTOM_ACC_WARN(3, "自定义账户预警"),
    ACC_WARN(4, "总帐户预警")
    ;

    private Integer code;
    private String desc;

    BigTextTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Integer,BigTextTypeEnum> typeMap = Maps.newHashMap();
    static{
        for(BigTextTypeEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static BigTextTypeEnum getByCode(Integer code){
        if(code == null ){
            return null;
        }
        return typeMap.get(code);
    }

}
