package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/1/2.
 */
public enum RedAccPeriodStatusEnum {
    UNSTART(1, "未开始"),
    OPEN(2, "已开启"),
    SETTLEMENT(3, "待结算"),//中间状态，不实际存储
    OVER(4, "已结束");

    private static Map<Integer, RedAccPeriodStatusEnum> codeMap = new HashMap<>();
    static {
        for(RedAccPeriodStatusEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static RedAccPeriodStatusEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    RedAccPeriodStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
