package cn.com.duiba.activity.common.center.api.remoteservice.black;

import cn.com.duiba.activity.common.center.api.dto.black.DeveloperBlackActivityDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * ClassName:RemoteDeveloperActivityBlackBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 负责管理员端  把活动添加到黑名单和删除黑名单
 * @date 创建时间：2018/4/3  15:31
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemoteDeveloperActivityBlackBackendService {

    /**
     *
     * 根据活动id 类型查询所有开启黑名单的开发者数量
     *
     * @param activityId
     * @param activityType
     *
     * @return
     * @since JDK 1.8
     */
    Integer findCountByActivityIdAndActivityType(Long activityId, Integer activityType);

    /**
     *
     * 根据活动id 类型查询所有开启黑名单的开发者
     *
     * @param activityId
     * @param activityType
     * @param offset
     * @param max
     *
     * @return
     * @since JDK 1.8
     */
    List<DeveloperBlackActivityDto> findByActivityIdAndActivityType(Long activityId, Integer activityType, Integer offset, Integer max);

    /**
     *
     * 批量查询插入黑名单
     *
     * @param developers
     *
     * @return
     * @since JDK 1.8
     */
    Integer insertBlackList4Developer(List<DeveloperBlackActivityDto> developers);

    /**
     *
     * 删除黑名单
     *
     * @param blackId
     *
     * @return
     * @since JDK 1.8
     */
    Integer deleteBlackById(Long blackId);
}