package cn.com.duiba.activity.common.center.api.remoteservice.brick;

import cn.com.duiba.activity.common.center.api.dto.brick.PopupActivityBrickDto;
import cn.com.duiba.activity.common.center.api.dto.brick.PopupActivityBrickSimpleDto;
import cn.com.duiba.activity.common.center.api.params.brick.PopuActivityParam;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * ClassName:RemotePopuActivityBackendService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 皮肤修改 管理员后端使用 无缓存
 * @date 创建时间：2018/3/19  11:54
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemotePopuActivityBackendService {
    /**
     *
     * findPage:只是简单列表数据,不带有皮肤数据
     * 查询皮肤list
     * @param param
     * @return
     * @since JDK 1.6
     */
    List<PopupActivityBrickDto> findPage(PopuActivityParam param);

    /**
     * 分页查询数据所有字段内容都值
     *
     * @param param
     * @return
     */
    List<PopupActivityBrickDto> findPageWithAll(PopuActivityParam param);

    /**
     *
     * findPageCount
     * 查询皮肤list条数
     * @param param
     * @return
     * @since JDK 1.6
     */
    Integer findPageCount(PopuActivityParam param);

    /**
     *
     * findById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询皮肤
     * @param id
     * @return
     * @since JDK 1.6
     */
    PopupActivityBrickDto findById(Long id) throws BizException;

    /**
     *
     * update:(这里用一句话描述这个方法的作用). <br/>
     * 编辑签到皮肤
     * @param brick
     * @return
     * @since JDK 1.6
     */
    PopupActivityBrickDto saveOrUpdatePopupActivityBrick(PopupActivityBrickDto brick);

    /**
     *
     * showOrHiddenBrick:(这里用一句话描述这个方法的作用). <br/>
     * 展示或者隐藏皮肤
     * @param id
     * @param status  0：关闭，1：开启
     * @return
     * @since JDK 1.6
     */
    Integer showOrHiddenBrick(Long id,Integer status);

    /**
     * 根据ID批量查询
     * @param type
     * @param ids
     * @return
     */
    List<PopupActivityBrickSimpleDto> batchFindByTypeAndIds(Integer type, List<Long> ids);
}
