package cn.com.duiba.activity.common.center.api.remoteservice.sharecode;

import cn.com.duiba.activity.common.center.api.dto.sharecode.OfficialShareCodeDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhangruofan
 * @date 2018/04/09
 */
@AdvancedFeignClient
public interface RemoteBackendOfficialShareCodeService {
    /**
     * 保存官方邀请码
     * @param  officialShareCodeDto 邀请码Dto
     * @return Long id
     * @throws BizException bizException
     */
    Long insert(OfficialShareCodeDto officialShareCodeDto) throws BizException;

    /**
     * 更新官方邀请码
     * @param officialShareCodeDto 邀请码Dto
     * @return 更新是否成功
     * @throws BizException bizException
     */
    Integer update(OfficialShareCodeDto officialShareCodeDto) throws BizException;

    /**
     * 删除官方邀请码
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return 删除是否成功
     * @throws BizException bizException
     */
    Integer delete(Long activityId, String activityType) throws BizException;

    /**
     * 通过活动获取官方邀请码
     * @param activityId 活动id
     * @param activityType 活动类型
     * @return OfficialShareCodeDto
     */
    OfficialShareCodeDto findByActivity(Long activityId, String activityType) throws BizException;
}
