package cn.com.duiba.activity.common.center.api.remoteservice.wallet;

import cn.com.duiba.activity.common.center.api.dto.wallet.WalletAccountDto;
import cn.com.duiba.activity.common.center.api.dto.wallet.WalletAccountRelationDto;
import cn.com.duiba.activity.common.center.api.params.wallet.WalletAccountParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * ClassName: RemoteWalletAccountBackendService.java <br/>
 * 
 * date: 2018年6月27日 <br/>
 * 
 * @Description: 全局钱包接口 管理员端使用
 * @author gey
 * @version V1.0
 * @since JDK 1.8
 */
@AdvancedFeignClient
public interface RemoteWalletAccountBackendService {

	/**
	 *
	 * insertOrUpdateWallAccount:新增或者更新全局钱包 <br/>
	 * 
	 * @param dto
	 * @return
	 * @since JDK 1.8
	 */
	public Integer insertOrUpdateWallAccount(WalletAccountDto dto);

	/**
	 * 开发者后台使用,默认会插入state(钱包开启状态)
	 * @param dto
	 * @return
	 */
	public Long insertAll(WalletAccountDto dto);
	/**
	 *
	 * findByid:根据id 查询 <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.8
	 */
	public WalletAccountDto findById(Long id);

	/**
	 *
	 * findAllWalletAccount:查询所有钱包 <br/>
	 * 
	 * @param param
	 * @return
	 * @since JDK 1.8
	 */
	public PageInfo<WalletAccountDto> findAllWalletAccount(WalletAccountParam param);

	/**
	 *
	 * delWallAccount:删除全局红包 <br/>
	 * 
	 * @param id
	 * @return
	 * @since JDK 1.8
	 */
	public Integer delWallAccount(Long id);

	/**
	 *
	 * findAllWalletAccountRelation:查询所有钱包关联关系 <br/>
	 * 
	 * @param walletId
	 * @return
	 * @since JDK 1.8
	 */
	public List<WalletAccountRelationDto> findAllWalletAccountRelation(Long walletId);

	/**
	 *
	 * saveWalletAccountRelation:保存所有钱包关联关系 <br/>
	 * 
	 * @param walletId
	 * @param appIds
	 * @return
	 * @since JDK 1.8
	 */
	public Integer saveWalletAccountRelation(Long walletId, List<Long> appIds);

	/**
	 *
	 * delWalletAccountRelation:删除钱包关联关系 <br/>
	 * 
	 * @param walletId
	 * @param appId
	 * @return
	 * @since JDK 1.8
	 */
	public Integer delWalletAccountRelation(Long walletId, Long appId);

}
