package cn.com.duiba.activity.common.center.api.params;

import cn.com.duiba.activity.common.center.api.enums.consumeraccounts.AccountTypeEnum;

import java.io.Serializable;

/**
 * Created by xiaoxuda on 2018/5/4.
 */
public class ConsumerAccountInsertParam implements Serializable {
    private static final long serialVersionUID = -4232666878831771341L;

    /**
     * 兑吧用户ID
     */
    private Long consumerId;
    /**
     * 业务类型,不再暴露给外部使用
     */
    private AccountTypeEnum accountType;
    /**
     * 业务涉及到的ID，可为null,默认设置为0
     */
    private Long relId = 0L;
    /**
     * 开发者uid
     */
    private String partnerUserId;
    /**
     * appID
     */
    private Long appId;

    public ConsumerAccountInsertParam(Long consumerId, AccountTypeEnum accountType, String partnerUserId, Long appId, Long relId) {
        this.consumerId = consumerId;
        this.accountType = accountType;
        this.relId = relId;
        this.partnerUserId = partnerUserId;
        this.appId = appId;
    }

    public ConsumerAccountInsertParam(){}

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public AccountTypeEnum getAccountType() {
        return accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public Long getRelId() {
        return relId;
    }

    public void setRelId(Long relId) {
        this.relId = relId;
    }

    public String getPartnerUserId() {
        return partnerUserId;
    }

    public void setPartnerUserId(String partnerUserId) {
        this.partnerUserId = partnerUserId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }
}
