package cn.com.duiba.activity.common.center.api.remoteservice.brick;

import cn.com.duiba.activity.common.center.api.dto.brick.PopupActivityBrickDto;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

/**
 * ClassName:RemotePopuActivityService<br/>
 *
 * @author gey
 * @version 1.0
 * @Description: 皮肤获取 通用接口  有redis 缓存
 * @date 创建时间：2018/3/19  11:54
 * @since JDK 1.8
 **/
@AdvancedFeignClient
public interface RemotePopuActivityService {

    /**
     * findBrickById:(这里用一句话描述这个方法的作用). <br/>
     * 根据Id查询皮肤
     * @param id
     * @return
     * @since JDK 1.6
     */
    PopupActivityBrickDto findBrickById(Long id) throws BizException;

    /**
     * 根据皮肤id查询皮肤MD5
     * MD5值是根据皮肤内容 进行md5加密  当皮肤内容改变md5就会改变
     * 手机端展示时 根据md5值获取是否一致  可以让皮肤立即生效
     * @param id
     * @return
     */
    String findMd5ById(Long id) throws BizException;

    /**
     * 根据ids查询皮肤
     *  key:皮肤id,value:皮肤内容
     * @param ids
     * @return
     */
    Map<Long,String> batchFindByIds(List<Long> ids);
}
