package cn.com.duiba.activity.common.center.api.remoteservice.actrecord;

import cn.com.duiba.activity.common.center.api.dto.actrecord.ActUserStateRecordDto;
import cn.com.duiba.activity.common.center.api.dto.actrecord.ActUserStateRecordSimpleDto;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * 活动用户状态记录Service
 * author zhanghuifeng
 * date 2019-03-20-18:10
 */
@AdvancedFeignClient
public interface RemoteActUserStateRecordService {

    /**
     * 获取当前活动满足状态人数
     * @param activityId
     * @param activityType @see ActivityUniformityTypeEnum
     * @param state @see ActUserStateEnum
     * @return
     */
    Long findCountAllActUserState(Long activityId, Integer activityType, Integer state);

    /**
     * 获取当前活动的用户当前状态
     * @param activityId
     * @param activityType @see ActivityUniformityTypeEnum
     * @param consumerId
     * @param state @see ActUserStateEnum
     * @return true:符合状态,false:不符合状态
     */
    Boolean findActUserState(Long activityId, Integer activityType, Long consumerId, Integer state);

    Long insert(ActUserStateRecordDto dto);

    /**
     * 单个更新活动用户状态
     * @param activityId
     * @param activityType @see ActivityUniformityTypeEnum
     * @param consumerId
     * @param state @see ActUserStateEnum
     * @return
     */
    Boolean updateActUserState(Long activityId, Integer activityType, Long consumerId, Integer state);

    /**
     * 批量更新活动用户状态
     * activityType->cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     * @param state @see ActUserStateEnum
     * @return
     */
    Boolean batchUpdateActUserState(List<Long> consumerIds, Long activityId, Integer activityType, Integer state);

    /**
     * 查询活动所有满足状态的用户
     *
     * @param activityType  cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     * @param state @see ActUserStateEnum
     * @return
     */
    List<Long> findAllActUserState(Long activityId, Integer activityType,Integer state);

    /**
     * 查询活动所有满足状态的用户
     *
     * @param activityType  cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     * @param state @see ActUserStateEnum
     * @return
     */
    List<ActUserStateRecordSimpleDto> findSimpleActUserInfo(Integer activityType,Integer state);

    /**
     * 查询活动所有满足状态的用户ID和活动ID信息
     *
     * @param activityType  cn.com.duiba.api.enums.ActivityUniformityTypeEnum
     * @param state @see ActUserStateEnum
     * @return
     */
    List<ActUserStateRecordSimpleDto> findAllActListUserState(List<Long> activityIds, Integer activityType,Integer state);

    /**
     * 不存在插入 存在则只更新状态
     * @param dto
     * @return
     */
    Long insertExistUpdateState(ActUserStateRecordDto dto);
}
