package cn.com.duiba.activity.common.center.api.remoteservice.activitygroup;

import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityDTO;
import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDTO;
import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupDetailDTO;
import cn.com.duiba.activity.common.center.api.dto.activitygroup.ActivityGroupUpdateDTO;
import cn.com.duiba.activity.common.center.api.params.activitygroup.ActivityGroupParam;
import cn.com.duiba.activity.common.center.api.params.activitygroup.ActivityParam;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * @author zhangruofan
 * @date 2018/03/20
 */
@AdvancedFeignClient
public interface RemoteActivityGroupBackendService {
    /**
     * 获取活动组配置列表
     * @param pageNum 页码
     * @param pageSize 页面大小
     * @return PageInfo<ActivityGroupDTO>
     */
    PageInfo<ActivityGroupDTO> list(Integer pageNum, Integer pageSize);


    /**
     * 通过Id获取活动组所有配置
     * @param id id
     * @return ActivityGroupDTO
     */
    ActivityGroupDetailDTO findById(Long id);

    /**
     * 新建活动组配置
     * @param activityGroup 活动组基本配置
     * @param activityList 活动组中的活动列表，可以为空
     * @return ActivityGroupDetailDTO
     */
    ActivityGroupDetailDTO create(ActivityGroupParam activityGroup, List<ActivityParam> activityList);

    /**
     * 更新活动组配置
     * @param activityGroup 活动组基本配置
     * @param activityList 活动组中的活动列表，可以为空
     * @return ActivityGroupUpdateDTO
     */
    ActivityGroupUpdateDTO update(ActivityGroupParam activityGroup, List<ActivityParam> activityList);

    /**
     * 软删除活动组配置
     * @param id 活动组Id
     * @return 成功数
     */
    ActivityGroupDetailDTO remove(Long id);

    /**
     * 活动是否在活动组
     * @param activityDTOList 活动列表
     * @return 在活动组的活动列表
     */
    List<ActivityDTO> isInActivityGroup(List<ActivityDTO> activityDTOList);
}
