package cn.com.duiba.activity.common.center.api.remoteservice.share;

import cn.com.duiba.activity.common.center.api.dto.share.CommonShareConfDto;
import cn.com.duiba.activity.common.center.api.enums.share.ShareRelTypeEnum;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
/**
 * @author xiaoxuda
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteCommonShareConfService {
	/**
	 * 新增数据
	 * @return 数据ID
	 */
	Long insert(CommonShareConfDto dto);
	
	/**
	 * 更新数据
	 */
	Boolean updateById(CommonShareConfDto dto);
	
	/**
	 * 不更新NULL字段
	 * @param dto
	 * @return
	 */
	Boolean updateSelectiveById(CommonShareConfDto dto);

	/**
	 * 根据ID删除指定数据
	 */
	Boolean deleteById(Long id);

	/**
	 * 根据ID查询指定数据
	 */
	CommonShareConfDto selectById(Long id);

	/**
	 * 唯一键查询
	 * @param relType
	 * @param relId
	 * @return
	 */
	CommonShareConfDto findByUK(ShareRelTypeEnum relType, Long relId);
}