package cn.com.duiba.activity.common.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2019/1/2.
 */
public enum RedAccPeriodRelTypeEnum {
    BUICK(1, "搬砖工"),
    PK(2, "组件pk"),
    PLANT_RED(3, "种红包"),
    REWARD_POPUP(4, "7天新人弹窗"),
    PYRAMID_SPREAD(5, "全民赚佣金"),
    ;

    private static Map<Integer, RedAccPeriodRelTypeEnum> codeMap = new HashMap<>();
    static {
        for(RedAccPeriodRelTypeEnum type : values()){
            codeMap.put(type.getCode(), type);
        }
    }

    public static RedAccPeriodRelTypeEnum getByCode(Integer code){
        return codeMap.get(code);
    }

    private Integer code;
    private String desc;

    RedAccPeriodRelTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
