package cn.com.duiba.activity.common.center.api.enums.consumeraccounts;

/**
 * 用户账户变更业务类型
 * 变更账户余额的具体业务类型
 */
public enum AccountBizTypeEnum {

    BIZ_HD_TOOL_ACTIVITY("活动工具", 0),

    BIZ_PLUGIN_ACTIVITY("插件活动", 1),

    BIZ_CASH_DRAWS_PAY("提现支付", 2),

    BIZ_CASH_DRAWS_BACK("提现回滚", 3),

    LOGIN("登录加经验", 4),

    EXCHANGE("兑换", 5),

    ACTIVITY("参加活动", 6),

    PK_ACTIVITY("PK押注活动", 7),

    SEVEN_DAY_REWARD("七天红包", 8),

    PK_ACTIVITY_WALLET("PK押注活动钱包", 9),

    PK_ACTIVITY_EXPIRE("钱包过期", 10),

    SEED_RED_PACKET("种红包活动钱包", 11),

    GAME_CENTER("新游戏中心", 12),

    INVITED_USER_SIGN("被邀请用户激活奖励", 13),
    INVITED_USER_EVALUATION("被邀请用户评论奖励", 14),
    INVITED_USER_SHARE("被邀请用户分享奖励", 15),
    FRESH_USER_REWARD("新用户奖励", 16),

    STEAL_RED_PACKET("偷红包活动钱包", 17),

    ALL_WALLET_BUDGET("全局钱包预算扣除", 18),

    AUTOMATED_TESTING("测试用-自动化测试用例", 19),

	SHARE_MASTER_REWARD("徒弟分享后师傅获得的奖励", 20),
	SHARE_REWARD("用户分享奖励", 21),

	LOTTERY_SQUARE("红包广场", 22),

    BRICK("搬砖活动", 23),

    SIGN("日历签到", 24),//凡是可以使用tb_sign_log表做签到记录的都可以使用这个类型

    SIGN_SHARE("拉新签到分享", 25),

    SIGN_SHARE_HELP("拉新签到分享助力", 26),

    SCRAPE_RED_PACKET("微信刮红包活动", 27),
    
    NEW_CONSUMER_7DAY_POPUP("7天激励弹窗", 28),

    PYRAMID_SPREAD("全民赚佣金", 29),

    ;

    AccountBizTypeEnum(String desc, Integer code) {
        this.code = code;
        this.desc = desc;
    }

    /** 描述 */
    private String desc;
    /** 类型码 */
    private Integer code;

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }

}
