package cn.com.duiba.activity.common.center.api.constants;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 2018/4/24.
 */
public enum WechatAccountInfo {
    /**
     * 运营直升机订阅号appId
     */
    WX_YUNYINGZSJ("wx0f69ba355f7210fd", "43fab83fb556333afd1691866bf67b96"),

    /**
     * 兑吧family订阅号
     */
    WX_DUIBAFAMILY("wxd15aebb2cb3320a9", "d1fc7059fbd238407bff5f213d9cd075"),

    /**
     * 奇货
     */
    WX_QIHO("wx46d2625b330f1e74", "a5ccddf8cb284b3c1c96cee649a29c42"),

    /**
     * 兑吧微信测试服务号
     */
    WX_DUIBA_TEST("wxcf95f7b323d2a2e3", "c62ceddce1990a5e2b438841d6757e4a"),

    /**
     * 客集集
     */
    WX_DUIBA_KJJ("wx1f0c8d3726b8808c", "ee3b17e91266f38f0621474fd8990ae2"),

    /**
     * 杭州麦严网络科技有限公司
     */
    WX_MAIYAN("wx129e3766a4a4bd47", "a623ae9bb829d2b0ad89103edefe5f81"),

    ;


    /**
     * 微信appId
     */
    private String wxAppId;

    /**
     * 【机密】密钥
     */
    private String wxAppSecrect;

    private static final Map<String, WechatAccountInfo> ENUM_MAP = new HashMap<>();

    static{
        for(WechatAccountInfo tmp : values()){
            ENUM_MAP.put(tmp.getWxAppId(), tmp);
        }
    }

    /**
     * 获取微信app配置，默认返回WX_YUNYINGZSJ
     * @param wxAppId
     * @return
     */
    public static WechatAccountInfo getByWxAppId(String wxAppId) {
        WechatAccountInfo info = ENUM_MAP.get(wxAppId);
        if (info == null) {
            return WX_YUNYINGZSJ;
        }
        return info;
    }

    WechatAccountInfo(String wxAppId, String wxAppSecrect) {

        this.wxAppId = wxAppId;
        this.wxAppSecrect = wxAppSecrect;
    }

    public String getWxAppId() {
        return wxAppId;
    }

    public String getWxAppSecrect() {
        return wxAppSecrect;
    }
}
